!!Note: 2 subroutines:
!   PlotPhaseGraph
!   SetPlotValues

SUBROUTINE PlotPhaseGraph

	USE Declare
	USE GraphsModule
	USE WindowsModule
	USE IFQWIN, ONLY: SETTEXTPOSITION, rccoord, SETACTIVEQQ, SETPIXELSRGB
	IMPLICIT NONE
	CHARACTER(22) RealToString
	TYPE (rccoord) curpos
	INTEGER(2) phase_pixel(0: n_plotpoints-1)
	INTEGER phaseColor (0:n_plotpoints-1)
	REAL(8) minimumPhase 
	REAL(8) maximumPhase 
	integer(4) :: SETACTIVEQQresult
    CHARACTER(12) IntToString

	phaseColor = #FFFFFF

	IF (plotProfile .AND. plotPhase) THEN
		upper_graphs_height = 12
		CALL CreateWindow (PHASE_UNIT, n_plotpoints, upper_graphs_height*16, PHASE_TITLE)
		IF (plotMembrane) THEN
			CALL PositionWindow (PHASE_UNIT, int(2.5*legend_width)+1, upper_graphs_height + 2, -1, upper_graphs_height)
		ELSE
			CALL PositionWindow (PHASE_UNIT, legend_width+1, upper_graphs_height + 2, -1, upper_graphs_height)
		ENDIF
	SETACTIVEQQresult = SETACTIVEQQ (PHASE_UNIT) 

		IF (plotPositions) THEN
			CALL SetPlotValues(positionPhase)
		ELSE
			CALL SetPlotValues(velocityPhase)
		ENDIF

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
! Store Velocity Phase Array
!OPEN (159, FILE = TRIM(OutputDirectory) // "Fase" // TRIM(IntToString(INT(signal1Frequency)))//".dat", FORM = 'BINARY')
!DO i=0, n_plotpoints-1
!	WRITE (159) SNGL(velocityPhase(i))
!ENDDO
!CLOSE (159)
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

		CALL SETTEXTPOSITION (INT2(0), INT2(0), curpos)
		WRITE (PHASE_UNIT, '($A7)') (TRIM(RealToString(maximumPhase, 1)) // " pi")
		CALL SETTEXTPOSITION (INT2(upper_graphs_height), INT2(0), curpos)
		WRITE (PHASE_UNIT, '($A7)') (TRIM(RealToString(minimumPhase, 1)) // " pi")

		CALL SETPIXELSRGB (n_plotpoints, section_axis, phase_pixel, phaseColor) 

	ENDIF

CONTAINS

	SUBROUTINE SetPlotValues(PhaseArray)
		IMPLICIT NONE
		REAL(8) PhaseArray(0:n_plotpoints - 1)

		! lower and upper boundary of window will be set to a multiple of .5 so that the entire graph fits into the window
		minimumPhase = .5d0 * FLOOR(MINVAL(PhaseArray) * 2)
		maximumPhase = .5d0 * CEILING(MAXVAL(PhaseArray, MASK = PhaseArray < 1000) * 2)
		phase_pixel = (- (PhaseArray - minimumPhase) / (maximumPhase - minimumPhase) + 1) * (upper_graphs_height * 16 -1)
	END SUBROUTINE SetPlotValues

END SUBROUTINE PlotPhaseGraph
